#!/bin/bash

# Get the directory of the script
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# Log file location
LOG_FILE="$SCRIPT_DIR/install_x11vnc.log"

# Function to print messages to both the screen and log file
function print_message() {
    message=$1
    echo $message | DISPLAY=:0 aosd_cat -R red -x 130 -y -510 -u 2000 -n "Arial Black 30"
    echo $message
    echo "$(date +'%Y-%m-%d %H:%M:%S') - $message" >> "$LOG_FILE"
}

# Function to print error messages and exit
function print_error() {
    error_message=$1
    print_message "Error: $error_message"
    exit 1
}

# Set the path to the 'packages' directory relative to the script's location
PACKAGES_DIR="$SCRIPT_DIR/packages"

# Redirect all output to the log file
exec &>> "$LOG_FILE"

# Check if x11vnc is available
if ! command -v x11vnc &>/dev/null; then
    # Install x11vnc and its dependencies from the 'packages' directory
    print_message "Installing x11vnc and dependencies..."
    sudo dpkg -R --install "$PACKAGES_DIR" || print_error "Failed to install x11vnc. See log file on USB drive."
    sudo apt-get install -f || print_error "Failed to resolve dependencies"

    # Check again if x11vnc is now available
    if ! command -v x11vnc &>/dev/null; then
        print_error "Failed to install x11vnc."
    fi
fi

# Launch x11vnc
print_message "Starting x11vnc..."
x11vnc -display :0 -noxrecord -noxdamage -shared -forever -o /tmp/x11vnc.log

# Print a message to indicate that x11vnc has started
print_message "x11vnc is running."
